use std::fs;
use std::io::Write;
use std::process::{Command, Stdio};
use tempfile::NamedTempFile;
use which::which;

pub fn display(string: &str) {
    if matches!(which("less"), Ok(_)) {
        let mut process = match Command::new("less").stdin(Stdio::piped()).spawn() {
            Err(msg) => panic!("Couldn't spawn less: {}", msg),
            Ok(process) => process,
        };

        match process.stdin.as_ref().unwrap().write_all(string.as_bytes()) {
            Err(msg) => panic!("Couldn't write to less stdin: {}", msg),
            Ok(_) => {}
        }

        process.wait().expect("`wait` failed");
    } else if matches!(which("more"), Ok(_)) {
        let tempfile = NamedTempFile::new().expect("Could not create temporary file");
        fs::write(&tempfile.path(), string).expect("Could not write to temporary file");
        Command::new("more")
            .arg(tempfile.path())
            .spawn()
            .expect("`more` failed")
            .wait()
            .expect("`wait` failed");
    } else {
        println!("{}", string);
    }
}
