//! Builder for creating a Settings template.
//!
//! <https://api.mangadex.org/docs.html#operation/post-settings-template>
//!
//! ```ignore
//! use mangadex_api::MangaDexClient;
//! use mangadex_api::types::{Password, Username};;
//!
//! # async fn run() -> anyhow::Result<()> {
//! let client = MangaDexClient::default();
//!
//! let _login_res = client
//!     .auth()
//!     .login()
//!     .username(Username::parse("myusername")?)
//!     .password(Password::parse("hunter23")?)
//!     .build()?
//!     .send()
//!     .await?;
//!
//! let res = client
//!     .settings()
//!     .create_template()
//!     .build()?
//!     .send()
//!     .await?;
//!
//! println!("Create Settings template: {:?}", res);
//! # Ok(())
//! # }
//! ```

use derive_builder::Builder;
use serde::Serialize;

// use crate::v5::schema::NoData;
use crate::HttpClientRef;
// use crate::Result;

/// Create a Settings template.
///
/// This requires authentication.
///
/// Makes a request to `POST /settings/template`.
#[derive(Debug, Builder, Serialize, Clone)]
#[serde(rename_all = "camelCase")]
#[builder(setter(into, strip_option))]
#[non_exhaustive]
pub struct CreateSettingsTemplate {
    /// This should never be set manually as this is only for internal use.
    #[doc(hidden)]
    #[serde(skip)]
    #[builder(pattern = "immutable")]
    #[allow(unused)]
    pub(crate) http_client: HttpClientRef,
}

// endpoint! {
//     POST "/settings/template",
//     #[body auth] CreateSettingsTemplate,
//     #[discard_result] Result<NoData>
// }

// #[cfg(test)]
// mod tests {
//     use serde_json::json;
//     use url::Url;
//     use uuid::Uuid;
//     use wiremock::matchers::{header, method, path};
//     use wiremock::{Mock, MockServer, ResponseTemplate};

//     use crate::error::Error;
//     use crate::{HttpClient, MangaDexClient};

//     #[tokio::test]
//     async fn create_settings_template_requires_auth() -> anyhow::Result<()> {
//         let mock_server = MockServer::start().await;
//         let http_client: HttpClient = HttpClient::builder()
//             .base_url(Url::parse(&mock_server.uri())?)
//             .build()?;
//         let mangadex_client = MangaDexClient::new_with_http_client(http_client);

//         let error_id = Uuid::new_v4();
//         let response_body = json!({
//             "result": "error",
//             "errors": [{
//                 "id": error_id.to_string(),
//                 "status": 403,
//                 "title": "Forbidden",
//                 "detail": "You must be logged in to continue."
//             }]
//         });

//         Mock::given(method("POST"))
//             .and(path("/settings/template"))
//             .and(header("Content-Type", "application/json"))
//             .respond_with(ResponseTemplate::new(403).set_body_json(response_body))
//             .expect(0)
//             .mount(&mock_server)
//             .await;

//         let res = mangadex_client
//             .settings()
//             .create_template()
//             .build()?
//             .send()
//             .await
//             .expect_err("expected error");

//         match res {
//             Error::MissingTokens => {}
//             _ => panic!("unexpected error: {:#?}", res),
//         }

//         Ok(())
//     }
// }
