use serde::Deserialize;
use url::Url;

use crate::types::{Language, MangaDexDateTime, MangaDexDuration};
use crate::v5::schema::LocalizedString;

/// General scanlation group information.
#[derive(Clone, Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
#[non_exhaustive]
pub struct ScanlationGroupAttributes {
    pub name: String,
    pub alt_names: Vec<LocalizedString>,
    pub website: Option<String>,
    pub irc_server: Option<String>,
    pub irc_channel: Option<String>,
    pub discord: Option<String>,
    pub contact_email: Option<String>,
    pub description: Option<String>,
    pub twitter: Option<Url>,
    /// Languages the scanlation primarily translates or uploads works into.
    pub focused_languages: Option<Vec<Language>>,
    pub locked: bool,
    pub official: bool,
    // Known issue: This field is unlisted on the MangaDex documentation but is present in the response.
    pub verified: bool,
    pub inactive: bool,
    /// Should respect PHP's DateInterval format: <https://www.php.net/manual/dateinterval.construct.php>
    ///
    /// Pattern: `^P(([1-9]|[1-9][0-9])D)?(([1-9])W)?(T(([1-9]|1[0-9]|2[0-4])H)?(([1-9]|[1-5][0-9]|60)M)?(([1-9]|[1-5][0-9]|60)S)?)?$`
    ///
    /// # Examples
    ///
    /// - Two days is `P2D`.
    /// - Two seconds is `PT2S`.
    /// - Six weeks and five minutes is `P6WT5M`.
    pub publish_delay: Option<MangaDexDuration>,
    pub version: u32,
    /// Datetime in `YYYY-MM-DDTHH:MM:SS+HH:MM` format.
    pub created_at: MangaDexDateTime,
    /// Datetime in `YYYY-MM-DDTHH:MM:SS+HH:MM` format.
    pub updated_at: MangaDexDateTime,
}
