#![doc = include_str!("../README.md")]
#![forbid(unsafe_code)]

#[macro_use]
pub mod common;
pub mod constants;
#[macro_use]
mod http_client;
pub mod types;
pub mod v5;

pub use constants::*;
pub use http_client::{HttpClient, HttpClientRef};
pub use v5::error::Error;
pub use v5::MangaDexClient;
pub use v5::Result;

#[cfg(all(feature = "chrono", feature = "time"))]
compile_error!("feature \"chrono\" and feature \"time\" cannot be enabled at the same time");
