//! Upload session file information from a response body.

use serde::Deserialize;

#[derive(Clone, Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct UploadSessionFileAttributes {
    pub original_file_name: String,
    pub file_hash: String,
    pub file_size: u64,
    pub mime_type: String,
    pub version: u32,
}

#[derive(Clone, Debug, Deserialize)]
pub struct UploadSessionFileData<A> {
    // The API docs don't specify the type that is in the `errors` array.
    #[serde(skip)]
    pub errors: Vec<String>,
    pub data: Vec<A>,
}
