//! Upload session information from a response body.

use chrono::{DateTime, Utc};
use serde::Deserialize;
use uuid::Uuid;

use crate::common::FromResponse;
use crate::types::RelationshipType;

#[derive(Clone, Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct UploadSessionAttributes {
    pub is_committed: bool,
    pub is_processed: bool,
    pub is_deleted: bool,
    pub version: u32,
    pub created_at: DateTime<Utc>,
    pub updated_at: DateTime<Utc>,
}

#[derive(Clone, Debug, Deserialize)]
pub struct UploadSessionResponse {
    pub id: Uuid,
    #[serde(rename = "type")]
    pub type_: RelationshipType,
    pub attributes: UploadSessionAttributes,
}

impl FromResponse for UploadSessionResponse {
    type Response = Self;

    fn from_response(value: Self::Response) -> Self {
        value
    }
}
