use chrono::{DateTime, Utc};
use serde::Deserialize;
use url::Url;

use crate::v5::schema::LocalizedString;

/// General author information.
#[derive(Clone, Debug, Deserialize, PartialEq)]
#[serde(rename_all = "camelCase")]
pub struct AuthorAttributes {
    pub name: String,
    pub image_url: Option<String>,
    // TODO: Known issue: Empty biography returns [] instead of {}.
    #[serde(skip)]
    pub biography: LocalizedString,
    pub twitter: Option<Url>,
    pub pixiv: Option<Url>,
    pub melon_book: Option<Url>,
    pub fan_box: Option<Url>,
    pub booth: Option<Url>,
    pub nico_video: Option<Url>,
    pub skeb: Option<Url>,
    pub fantia: Option<Url>,
    pub tumblr: Option<Url>,
    pub youtube: Option<Url>,
    pub website: Option<Url>,
    pub version: u32,
    pub created_at: DateTime<Utc>,
    pub updated_at: Option<DateTime<Utc>>,
}
