use chrono::{DateTime, Utc};
use serde::Deserialize;

use crate::v5::schema::LocalizedString;

/// General author information.
#[derive(Clone, Debug, Deserialize, PartialEq)]
#[serde(rename_all = "camelCase")]
pub struct AuthorAttributes {
    pub name: String,
    pub image_url: Option<String>,
    // TODO: Known issue: Empty biography returns [] instead of {}.
    #[serde(skip)]
    pub biography: LocalizedString,
    pub version: u32,
    pub created_at: DateTime<Utc>,
    pub updated_at: Option<DateTime<Utc>>,
}
