//! MangaDex API response object types.

mod at_home_server;
mod auth_tokens;
mod author;
mod chapter;
mod check_token_response;
mod common;
mod cover;
mod custom_list;
mod error;
mod legacy_id_mapping;
mod login_response;
mod manga;
mod manga_aggregate;
mod manga_links;
mod manga_read_markers;
mod manga_reading_status;
mod manga_reading_statuses;
mod manga_request;
mod password;
mod refresh_token_response;
mod report;
mod scanlation_group;
mod tag;
#[cfg(feature = "upload")]
mod upload_session;
#[cfg(feature = "upload")]
mod upload_session_file;
mod user;
mod username;

use serde::{Deserialize, Serialize};

use crate::types::Language;
use crate::Result;
pub(crate) use at_home_server::AtHomeServer;
pub(crate) use auth_tokens::AuthTokens;
pub(crate) use author::AuthorAttributes;
pub(crate) use chapter::ChapterAttributes;
pub(crate) use check_token_response::CheckTokenResponse;
pub(crate) use common::*;
pub(crate) use cover::CoverAttributes;
pub(crate) use custom_list::CustomListAttributes;
pub(crate) use error::MangaDexErrorResponse;
pub(crate) use legacy_id_mapping::LegacyMappingIdAttributes;
pub(crate) use login_response::LoginResponse;
pub(crate) use manga::MangaAttributes;
pub(crate) use manga_aggregate::MangaAggregate;
pub(crate) use manga_links::MangaLinks;
pub(crate) use manga_read_markers::{MangaReadMarkers, UngroupedMangaReadMarkers};
pub(crate) use manga_reading_status::MangaReadingStatus;
pub(crate) use manga_reading_statuses::MangaReadingStatuses;
pub use password::Password;
pub(crate) use refresh_token_response::RefreshTokenResponse;
pub(crate) use report::ReportReasonAttributes;
pub(crate) use scanlation_group::ScanlationGroupAttributes;
pub(crate) use tag::TagAttributes;
#[cfg(feature = "upload")]
pub(crate) use upload_session::UploadSessionResponse;
#[cfg(feature = "upload")]
pub(crate) use upload_session_file::{UploadSessionFileAttributes, UploadSessionFileData};
pub(crate) use user::UserAttributes;
pub use username::Username;

/// Placeholder to hold response bodies that will be discarded.
///
/// `Result<()>` can't be used with the macro return type because it expects a unit type,
/// so a temporary struct is used.
///
/// # Examples
///
/// ```rust, ignore
/// endpoint! {
///     POST "/captcha/solve",
///     #[body] SolveCaptcha<'_>,
///     #[discard_result] Result<NoData> // `Result<()>` results in a deserialization error despite discarding the result.
/// }
#[derive(Debug, Default, Serialize, Deserialize, Clone, Hash, PartialEq, Eq)]
pub struct NoData;

pub type LocalizedString = std::collections::HashMap<Language, String>;

pub type AtHomeServerResponse = Result<AtHomeServer>;

pub type AuthorObject = ApiObject<AuthorAttributes>;
pub type AuthorData = ApiData<AuthorObject>;
pub type AuthorResponse = Result<AuthorData>;
pub type AuthorListResponse = Result<Results<AuthorObject>>;

pub type ChapterObject = ApiObject<ChapterAttributes>;
pub type ChapterData = ApiData<ChapterObject>;
pub type ChapterResponse = Result<ChapterData>;
pub type ChapterListResponse = Result<Results<ChapterObject>>;

pub type CoverObject = ApiObject<CoverAttributes>;
pub type CoverData = ApiData<CoverObject>;
pub type CoverResponse = Result<CoverData>;
pub type CoverListResponse = Result<Results<CoverObject>>;

pub type CustomListObject = ApiObject<CustomListAttributes>;
pub type CustomListData = ApiData<CustomListObject>;
pub type CustomListResponse = Result<CustomListData>;
pub type CustomListListResponse = Result<Results<CustomListObject>>;

pub type GroupObject = ApiObject<ScanlationGroupAttributes>;
pub type GroupData = ApiData<GroupObject>;
pub type GroupResponse = Result<GroupData>;
pub type GroupListResponse = Result<Results<GroupObject>>;

pub type IdMappingObject = ApiObject<LegacyMappingIdAttributes>;
pub type IdMappingData = ApiData<IdMappingObject>;
pub type IdMappingListResponse = Result<Results<IdMappingObject>>;

pub type MangaObject = ApiObject<MangaAttributes>;
pub type MangaData = ApiData<MangaObject>;
pub type MangaResponse = Result<MangaData>;
pub type MangaListResponse = Result<Results<MangaObject>>;

pub type MangaAggregateResponse = Result<MangaAggregate>;

pub type UngroupedMangaReadMarkersResponse = Result<UngroupedMangaReadMarkers>;
pub type MangaReadMarkersResponse = Result<MangaReadMarkers>;

pub type MangaReadingStatusResponse = Result<MangaReadingStatus>;
pub type MangaReadingStatusesResponse = Result<MangaReadingStatuses>;

pub type ReportReasonObject = ApiObjectNoRelationships<ReportReasonAttributes>;
pub type ReportReasonListResponse = Result<Results<ReportReasonObject>>;

pub type TagObject = ApiObject<TagAttributes>;
pub type TagData = ApiData<TagObject>;
pub type TagResponse = Result<TagData>;
pub type TagListResponse = Result<Results<TagObject>>;

#[cfg(feature = "upload")]
pub type UploadSessionFileObject = ApiObject<UploadSessionFileAttributes>;
#[cfg(feature = "upload")]
pub type UploadSessionFileResponse = Result<UploadSessionFileData<UploadSessionFileObject>>;

pub type UserObject = ApiObject<UserAttributes>;
pub type UserData = ApiData<UserObject>;
pub type UserResponse = Result<UserData>;
pub type UserListResponse = Result<Results<UserObject>>;
