use serde::Deserialize;

use crate::common::FromResponse;
use crate::v5::schema::AuthTokens;

/// The response when refreshing the session JWT.
#[derive(Clone, Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct RefreshTokenResponse {
    pub token: AuthTokens,
    pub message: Option<String>,
}

impl FromResponse for RefreshTokenResponse {
    type Response = Self;

    fn from_response(res: Self::Response) -> Self {
        res
    }
}
