use serde::Deserialize;

use std::collections::HashMap;

/// Response struct for the manga aggregate endpoint (GET `/manga/:id/aggregate`).
#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
pub struct MangaAggregate {
    /// Object with (volume_number, volume) key-value pairs.
    pub volumes: HashMap<String, VolumeAggregate>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
pub struct VolumeAggregate {
    /// Volume number.
    pub volume: String,
    /// Number of chapter translations for the volume.
    pub count: u32,
    /// Object with (chapter_number, chapter) key-value pairs.
    pub chapters: HashMap<String, ChapterAggregate>,
}

#[derive(Clone, Debug, Default, Deserialize, PartialEq)]
pub struct ChapterAggregate {
    /// Chapter number.
    pub chapter: String,
    /// Number of translations for the chapter.
    pub count: u32,
}
