use serde::{Deserialize, Serialize};

use crate::common::FromResponse;
use crate::v5::schema::AuthTokens;

#[derive(Debug, Serialize, Deserialize, Clone)]
#[serde(rename_all = "camelCase")]
pub struct LoginResponse {
    pub token: AuthTokens,
}

impl FromResponse for LoginResponse {
    type Response = Self;

    fn from_response(res: Self::Response) -> Self {
        res
    }
}
