use chrono::{DateTime, Utc};
use serde::Deserialize;

/// General cover information.
#[derive(Clone, Debug, Deserialize, PartialEq)]
#[serde(rename_all = "camelCase")]
pub struct CoverAttributes {
    pub description: String,
    /// Volume number in the manga.
    pub volume: Option<String>,
    /// Cover art filename as it's stored on the MangaDex servers.
    pub file_name: String,
    pub created_at: DateTime<Utc>,
    pub updated_at: Option<DateTime<Utc>>,
    pub version: u32,
}
