use serde::{Deserialize, Serialize};

use crate::types::TagGroup;
use crate::v5::schema::LocalizedString;

#[derive(Clone, Debug, Deserialize, Serialize, PartialEq)]
#[serde(rename_all = "camelCase")]
pub struct TagAttributes {
    pub name: LocalizedString,
    // TODO: Known issue: Empty descriptions return [] instead of {}.
    #[serde(skip)]
    pub description: LocalizedString,
    pub group: TagGroup,
    pub version: u32,
}
