use chrono::{DateTime, Utc};
use serde::Deserialize;

use crate::v5::schema::{ApiObject, UserAttributes};

/// General scanlation group information.
#[derive(Clone, Debug, Deserialize, PartialEq)]
#[serde(rename_all = "camelCase")]
pub struct ScanlationGroupAttributes {
    pub name: String,
    // This is only returned from the list endpoint.
    pub leader: Option<ApiObject<UserAttributes>>,
    // This is only returned from the list endpoint.
    pub members: Option<Vec<ApiObject<UserAttributes>>>,
    pub website: Option<String>,
    pub irc_server: Option<String>,
    pub irc_channel: Option<String>,
    pub discord: Option<String>,
    pub contact_email: Option<String>,
    pub description: Option<String>,
    pub locked: bool,
    pub version: u32,
    pub created_at: DateTime<Utc>,
    pub updated_at: DateTime<Utc>,
}
