use serde::Deserialize;
use url::Url;

use crate::common::FromResponse;

#[derive(Clone, Debug, Deserialize, PartialEq)]
#[serde(rename_all = "camelCase")]
pub struct AtHomeServer {
    /// The base URL to construct final image URLs from.
    /// The URL returned is valid for the requested chapter only, and for a duration of 15 minutes
    /// from the time of the response.
    pub base_url: Url,
}

impl FromResponse for AtHomeServer {
    type Response = Self;

    fn from_response(res: Self::Response) -> Self {
        res
    }
}
