//! Legacy endpoint handler.
//!
//! <https://api.mangadex.org/docs.html#tag/Legacy>

mod id_mapping;

use std::cell::RefCell;
use std::rc::Rc;

use crate::v5::legacy::id_mapping::LegacyIdMappingBuilder;
use crate::v5::HttpClient;

/// Legacy endpoint handler builder.
#[derive(Clone, Debug)]
pub struct LegacyBuilder {
    http_client: Rc<RefCell<HttpClient>>,
}

impl LegacyBuilder {
    pub fn new(http_client: Rc<RefCell<HttpClient>>) -> Self {
        Self { http_client }
    }

    /// Get the UUID of a resource from legacy numerical IDs.
    ///
    /// <https://api.mangadex.org/docs.html#operation/post-legacy-mapping>
    pub fn id_mapping(self) -> LegacyIdMappingBuilder {
        LegacyIdMappingBuilder::default().http_client(self.http_client)
    }
}
