//! Infrastructure endpoint handler.
//!
//! <https://api.mangadex.org/docs.html#tag/Infrastructure>

mod ping;

use std::cell::RefCell;
use std::rc::Rc;

use crate::v5::infrastructure::ping::PingBuilder;
use crate::v5::HttpClient;

/// Legacy endpoint handler builder.
#[derive(Clone, Debug)]
pub struct InfrastructureBuilder {
    http_client: Rc<RefCell<HttpClient>>,
}

impl InfrastructureBuilder {
    pub fn new(http_client: Rc<RefCell<HttpClient>>) -> Self {
        Self { http_client }
    }

    /// Ping the server.
    ///
    /// <https://api.mangadex.org/docs.html#tag/Infrastructure/paths/~1ping/get>
    pub fn ping(self) -> PingBuilder {
        PingBuilder::default().http_client(self.http_client)
    }
}
