//! CAPTCHA endpoint handler.
//!
//! <https://api.mangadex.org/docs.html#tag/Captcha>

mod solve;

use std::cell::RefCell;
use std::rc::Rc;

use crate::v5::captcha::solve::SolveCaptchaBuilder;
use crate::v5::HttpClient;

/// CAPTCHA endpoint handler builder.
#[derive(Debug)]
pub struct CaptchaBuilder {
    http_client: Rc<RefCell<HttpClient>>,
}

impl CaptchaBuilder {
    pub fn new(http_client: Rc<RefCell<HttpClient>>) -> Self {
        Self { http_client }
    }

    /// Solve a CAPTCHA challenge.
    ///
    /// <https://api.mangadex.org/docs.html#operation/post-captcha-solve>
    pub fn solve(&self) -> SolveCaptchaBuilder {
        SolveCaptchaBuilder::default().http_client(self.http_client.clone())
    }
}
