//! MangaDex@Home endpoint handler.
//!
//! <https://api.mangadex.org/docs.html#tag/AtHome>

mod server;

use std::cell::RefCell;
use std::rc::Rc;

use crate::v5::at_home::server::GetAtHomeServerBuilder;
use crate::v5::HttpClient;

/// MangaDex@Home endpoint handler builder.
#[derive(Debug)]
pub struct AtHomeBuilder {
    http_client: Rc<RefCell<HttpClient>>,
}

impl AtHomeBuilder {
    pub fn new(http_client: Rc<RefCell<HttpClient>>) -> Self {
        Self { http_client }
    }

    /// Get a MangaDex@Home server URL.
    ///
    /// <https://api.mangadex.org/docs.html#operation/get-at-home-server-chapterId>
    ///
    /// This can be used to [fetch chapter pages](https://api.mangadex.org/docs.html#section/Reading-a-chapter-using-the-API/Retrieving-pages-from-the-MangaDex@Home-network).
    pub fn server(&self) -> GetAtHomeServerBuilder {
        GetAtHomeServerBuilder::default().http_client(self.http_client.clone())
    }
}
