use serde::{Deserialize, Serialize};

#[derive(Clone, Copy, Debug, Deserialize, Hash, PartialEq, PartialOrd, Serialize)]
#[serde(rename_all = "lowercase")]
pub enum MangaStatus {
    /// Manga is still going on.
    Ongoing,
    /// Manga is completed.
    Completed,
    /// Manga is paused from publishing new chapters.
    Hiatus,
    /// Manga has been cancelled.
    Cancelled,
}

impl From<String> for MangaStatus {
    fn from(value: String) -> Self {
        match value.as_ref() {
            "ongoing" => Self::Ongoing,
            "completed" => Self::Completed,
            "hiatus" => Self::Hiatus,
            "cancelled" => Self::Cancelled,
            _ => Self::Ongoing,
        }
    }
}

impl std::fmt::Display for MangaStatus {
    fn fmt(&self, fmt: &mut std::fmt::Formatter) -> std::fmt::Result {
        let name = match self {
            Self::Ongoing => "ongoing",
            Self::Completed => "completed",
            Self::Hiatus => "hiatus",
            Self::Cancelled => "cancelled",
        };
        fmt.write_str(name)
    }
}
