use serde::{Deserialize, Serialize};

use crate::types::OrderDirection;

/// "Order by" fields to sort results.
#[derive(Debug, Serialize, Deserialize, Clone, Hash, PartialEq, Eq)]
#[serde(rename_all = "camelCase")]
pub enum AuthorSortOrder {
    Name(OrderDirection),
}

/// "Order by" fields to sort results.
#[derive(Debug, Serialize, Deserialize, Clone, Hash, PartialEq, Eq)]
#[serde(rename_all = "camelCase")]
pub enum ChapterSortOrder {
    CreatedAt(OrderDirection),
    UpdatedAt(OrderDirection),
    PublishAt(OrderDirection),
    Volume(OrderDirection),
    Chapter(OrderDirection),
}

/// "Order by" fields to sort results.
#[derive(Debug, Serialize, Deserialize, Clone, Hash, PartialEq, Eq)]
#[serde(rename_all = "camelCase")]
pub enum MangaSortOrder {
    CreatedAt(OrderDirection),
    UpdatedAt(OrderDirection),
}

/// "Order by" fields to sort results.
#[derive(Debug, Serialize, Deserialize, Clone, Hash, PartialEq, Eq)]
#[serde(rename_all = "camelCase")]
pub enum MangaFeedSortOrder {
    Chapter(OrderDirection),
    Volume(OrderDirection),
}

/// "Order by" fields to sort results.
#[derive(Debug, Serialize, Deserialize, Clone, Hash, PartialEq, Eq)]
#[serde(rename_all = "camelCase")]
pub enum UserSortOrder {
    Username(OrderDirection),
}
