use serde::Serialize;

/// "Order by" fields to sort results.
#[derive(Clone, Copy, Debug, Hash, PartialEq, PartialOrd, Serialize)]
pub enum OrderField {
    CreatedAt,
    UpdatedAt,
    PublishAt,
    Name,
    Volume,
    Username,
}

impl std::fmt::Display for OrderField {
    fn fmt(&self, fmt: &mut std::fmt::Formatter) -> std::fmt::Result {
        fmt.write_str(match self {
            Self::CreatedAt => "createdAt",
            Self::UpdatedAt => "updatedAt",
            Self::PublishAt => "publishAt",
            Self::Name => "name",
            Self::Volume => "volume",
            Self::Username => "username",
        })
    }
}

impl OrderField {
    pub fn as_query_param_str(&self) -> &'static str {
        match self {
            Self::CreatedAt => "order[createdAt]",
            Self::UpdatedAt => "order[updatedAt]",
            Self::PublishAt => "order[publishAt]",
            Self::Name => "order[name]",
            Self::Volume => "order[volume]",
            Self::Username => "order[username]",
        }
    }
}
