# MangaDex API

Unofficial Rust client for the MangaDex API.

*Warning:
This is still in the **early development stage**.
Some breaking API changes may occur as the project matures.
Consequently, this code is not yet ready for use in production.*

<!-- [Documentation (Published versions)](https://docs.rs/mangadex_api) -->
[Documentation (`main` branch)](https://gondolyr.gitlab.io/mangadex-api/mangadex_api)

# Table of Contents

* [Requirements][readme-section-requirements]
* [How to install][readme-section-install]
* [Features][readme-section-features]
* [Examples][readme-section-examples]
* [Running Examples][readme-section-running-examples]
* [License][readme-section-license]
* [Contribution][readme-section-contribution]
* [Contributing][readme-section-contributing]

# Requirements

[Back to top][readme-section-toc]

* [Rust 1.47+][rust-homepage]

## How to install

Add `mangadex-api` to your dependencies:

```toml
[dependencies]
# ...
mangadex-api = "1.0.0-alpha.0"
```

If you are using [`cargo-edit`](https://github.com/killercup/cargo-edit), run

```bash
cargo add mangadex-api
```

# Features

All features are not included by default. To enable them, add any of the following to your project's `Cargo.toml` file.

* `upload` - Enable endpoints that upload files to MangaDex.

For example, to enable the `upload` feature, add the following to your `Cargo.toml` file:

```toml
mangadex-api = { version = "1.0.0-alpha.0", features = ["upload"] }
```

# Downloading Cover Images

1. Get the list of covers from the [cover list endpoint](https://api.mangadex.org/docs.html#operation/get-cover).
2. Download the desired image from `https://uploads.mangadex.org` using the following format: `https://uploads.mangadex.org/:mangaId/:fileName`.

# Examples

[Back to top][readme-section-toc]

```rust
use mangadex_api::v5::MangaDexClient;

#[tokio::main]
async fn main() -> anyhow::Result<()> {
    let client = MangaDexClient::default();

    let random_manga = client
        .manga()
        .random()
        .build()?
        .send()
        .await?;

    println!("{:?}", random_manga);

    Ok(())
}
```

# Running Examples

[Back to top][readme-section-toc]

The examples can be run with the following:

```
cargo run --example [example_name]
```

More details about the examples can be found in the [examples README][examples-readme] file.

# Changelog

[Back to top][readme-section-toc]

The changelog can be found [here][changelog].

Changes are added manually to keep the changelog human-readable with summaries of the changes from each version.

# License

[Back to top][readme-section-toc]

Licensed under either of

 * Apache License, Version 2.0
   ([LICENSE-APACHE][license-apache] or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license
   ([LICENSE-MIT][license-mit] or http://opensource.org/licenses/MIT)

at your option.

## Contribution

[Back to top][readme-section-toc]

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.

# Contributing

[Back to top][readme-section-toc]

We welcome contributions from everyone. There are many ways to contribute and the
[CONTRIBUTING.md][contributing] document explains how you can contribute and get started.

[rust-homepage]: https://rust-lang.org

[changelog]: CHANGELOG.md
[contributing]: CONTRIBUTING.md
[examples-readme]: examples/README.md
[license-apache]: LICENSE-APACHE
[license-mit]: LICENSE-MIT

[readme-section-contributing]: #contributing
[readme-section-contribution]: #contribution
[readme-section-examples]: #examples
[readme-section-features]: #features
[readme-section-install]: #how-to-install
[readme-section-license]: #license
[readme-section-requirements]: #requirements
[readme-section-running-examples]: #running-examples
[readme-requirements]: #requirements
[readme-section-toc]: #table-of-contents
