# Version 1.0.0-alpha.0 (2021-08-23)

I am pleased to announce the first public release of the rewrite of `mangadex-api`, which has feature parity with the [v5 MangaDex API]((https://api.mangadex.org/docs.html)!

The ergonomics of the library are still being adjusted but all of the available public endpoints (as of 5.2.20) are available for use with this library. While the library is in its 1.0.0 alpha state, small adjustments and fixes are expected before a 1.0.0 release.

A major change is the error handling where more descriptive errors are provided.

The "Upload" category is hidden behind the `upload` feature because it is experimental but should be overall functional.

Please report any issues or suggestions to the project at https://gitlab.com/gondolyr/mangadex-api/-/issues.

# Version 0.2.6 (2021-03-21)

## Changed

- [Add basic error handling when the MangaDex servers return an HTTP error code][ee414061]
    - This was discovered when MangaDex required extended maintenance time to resolve issues on their end.

[ee414061]: https://gitlab.com/gondolyr/mangadex-api/-/commit/ee414061c772bace7ed441b66ecb1a9186aac50c

# Version 0.2.5 (2021-03-11)

## Added

- [`Display` trait on the Demographic and PublicationStatus enums][c3744870]

## Changed

- [Blank manga artists are filtered out from the v2 `/manga/{id}` endpoint response so that consumers of this library don't have to do it themselves][0ca81a38]

## Documentation

- [Group `delay` field now has a more accurate description][172937df]
- [Clarified the `md_at_home` field's purpose][2ebd4663]
- [Added descriptions for manga response fields][1633138c]
- [Added a description for the `TagData.group` partial struct field][a7021282]

## Fixed

- [The `GroupChaptersResponse` struct now uses the `ChaptersDataPartial` struct for the `data` field to match the API's response structure][10ae6be7]
- [The `group_chapters()` v2 client builder method now uses the correct `GroupId` type alias for the `id` parameter][43800678]

[c3744870]: https://gitlab.com/gondolyr/mangadex-api/-/commit/c374487066ab2f3d151aa42ec394816876250180
[0ca81a38]: https://gitlab.com/gondolyr/mangadex-api/-/commit/0ca81a3807966846ca807066c8ebb20da22a98dc
[10ae6be7]: https://gitlab.com/gondolyr/mangadex-api/-/commit/10ae6be7b574470a1ddef7b9a30350fecdd7f0a9
[43800678]: https://gitlab.com/gondolyr/mangadex-api/-/commit/43800678508be9a84ae31e09748c43ede29b268b
[172937df]: https://gitlab.com/gondolyr/mangadex-api/-/commit/172937df8d13fa6498c3d00e0f6168e795e28e80
[2ebd4663]: https://gitlab.com/gondolyr/mangadex-api/-/commit/2ebd4663bdb657c360ddb5f471d69ec8a4d6b790
[1633138c]: https://gitlab.com/gondolyr/mangadex-api/-/commit/1633138cbb974d57d3c64f10af3b9267d3d94044
[a7021282]: https://gitlab.com/gondolyr/mangadex-api/-/commit/a7021282112b3a7ca838b2f98ace14bdc2f84c3c

# Version 0.2.4 (2021-03-05)

## Changed

- [Web scrape clients include `Send + Sync` traits][f8008011]

## Documentation

- [Add flags to include all features and document private items when publishing to docs.rs][5a4f7a2f]

[5a4f7a2f]: https://gitlab.com/gondolyr/mangadex-api/-/commit/5a4f7a2f69c434aeeeb76a114ccce58613cf49db
[f8008011]: https://gitlab.com/gondolyr/mangadex-api/-/commit/f80080119bad511b9037f20249480c5d398fc53e

# Version 0.2.3 (2021-01-16)

## Added

- [`thread_id` field to `ChapterPartial` struct][1a6cf334]
- [Added `read` field to the v2 followed-updates endpoint response][409d61df]
- [Added `blockgroups` query parameter to all endpoints that return a list of chapters][c6e7e2db]. Enabling this filters out chapters belonging to groups that the user has blocked.
    - `/v2/group/{id}/chapters`
    - `/v2/manga/{id}/chapters`
    - `/v2/user/{id|me}/chapters`
    - `/v2/user/{id|me}/followed-updates`
- [Added `type` and `hentai` parameters to the v2 followed-manga endpoint][e8689022]. These are the same parameters that the followed-updates endpoint permitted.

## Changed

- [Base API URL now points to `api.mangadex.org`][c2870def]
- [The followed-updates response struct now uses the `title` field instead of `name`][6bdada80]. The `name()` getter has been preserved to maintain compatiblity for those using `name()`.

## Documentation

- [Add `threadId` field to the v2 OpenAPI document][a9284838]

## Fixed

- ["external" chapter status types are able to be parsed][48513b38]
- [The response struct for the v2 manga chapters endpoint (`/v2/manga/{id}/chapters`) has been fixed][71851fa5]. Previously, it was using the wrong struct for the `data` field.

[c2870def]: https://gitlab.com/gondolyr/mangadex-api/-/commit/c2870def1f9e509449e147f7de0d6abcf2274f0d
[6bdada80]: https://gitlab.com/gondolyr/mangadex-api/-/commit/6bdada801b9a9a829c4e46bd15f2872b20c3aa3c
[409d61df]: https://gitlab.com/gondolyr/mangadex-api/-/commit/409d61dfbbdb2657707819af10ef36f38d00e1d1
[48513b38]: https://gitlab.com/gondolyr/mangadex-api/-/commit/48513b385fa55580a683ccb8a48ff45327064860
[c6e7e2db]: https://gitlab.com/gondolyr/mangadex-api/-/commit/c6e7e2db7b5bc2356d5cdb2d8de7f3fca5dc376e
[e8689022]: https://gitlab.com/gondolyr/mangadex-api/-/commit/bd01b61ff69f2a3eb8ea39ab94ea331cce4ff52c
[71851fa5]: https://gitlab.com/gondolyr/mangadex-api/-/commit/71851fa5e27ee97ce8e14aa09bf86fc481d80c81
[1a6cf334]: https://gitlab.com/gondolyr/mangadex-api/-/commit/1a6cf334ef64800af22f7548d12531326b2dbc6c
[a9284838]: https://gitlab.com/gondolyr/mangadex-api/-/commit/a928483880bca18c72b5ca051858c4cd98e752f6

# Version 0.2.2 (2021-01-08)

## Dependencies

- [Update Reqwest to 0.11][b8e82c6]
- [Update Tokio to 1.0][b8e82c6]

[b8e82c6]: https://gitlab.com/gondolyr/mangadex-api/-/commit/b8e82c6d414717dabfa8c6650f6bf52f16c4dc99

# Version 0.2.0 (2020-12-29)

The web scraping search, fetch latest updates, and most popular manga functionality
all return a struct with the manga ID, title, and cover image URL.

## Added

- [Added `SiteTheme` enum for choosing the website theme][fc45db0]
- [Added functionality to fetch the latest manga updates via web scraping][bcfd464]
- [Added search functionality via web scraping][84216cb]
- [Added functionality to fetch the most popular manga (highest Bayesian rating) via web scraping][2d616df]
- [Added a `builder()` method to the `MangaDexV2` struct to allow for API configuration for things such as the user agent][f5874bd]
- [Added `tags()` method to `TagCategory` enum to return the associated tags with the category][0375fe6]

## Changed

- \[BREAKING\] [Changed `Language` default value to `English` because MangaDex appears to default to this language][9804cab]
- \[BREAKING\] [Make "time"/"Chrono" feature on by default to make it easier to work with dates and times][66845e9]
- [Changed enum function arguments to accept generic values for improved flexibility][8f296ef]
- [Make `Language` enum `From` trait implementations case-insensitive][4b522b9]

## Examples

- [Added login example to README][2705240]

## Fixed

- [Fixed `Language::Other` integer value][9804cab]

## Internal Only

- [Implement `FromStr` trait on Language enum][2c4d698]
- [Removed patch versions from Cargo.toml because the latest patch fixes should not include any breaking
  changes and should instead bring the latest fixes][2891a55]

[2c4d698]: https://gitlab.com/gondolyr/mangadex-api/-/commit/2c4d69860f729579bcffbfaacdd11c3bf0d79421
[fc45db0]: https://gitlab.com/gondolyr/mangadex-api/-/commit/fc45db08c500cec8a665351a4df3dd90e80f664a
[9804cab]: https://gitlab.com/gondolyr/mangadex-api/-/commit/9804cab889284de1a463bedf8fd6e33fa945930d
[bcfd464]: https://gitlab.com/gondolyr/mangadex-api/-/commit/bcfd4641c9ad74b88c7c2783fdb2af6e1776f4d6
[84216cb]: https://gitlab.com/gondolyr/mangadex-api/-/commit/84216cbe3a930bdf6db1f271c1dd0749d42a0b9a
[8f296ef]: https://gitlab.com/gondolyr/mangadex-api/-/commit/8f296efaa8a0583bf9722229de773bd8abfb468b
[66845e9]: https://gitlab.com/gondolyr/mangadex-api/-/commit/66845e9dc3fffed4289353bcf7e68f002f65343b
[2d616df]: https://gitlab.com/gondolyr/mangadex-api/-/commit/2d616dfdab870eacb9e1b348b2c6cf1da129c0b6
[f5874bd]: https://gitlab.com/gondolyr/mangadex-api/-/commit/f5874bd6e5fb826e99beec7cd56a89b86c917678
[4b522b9]: https://gitlab.com/gondolyr/mangadex-api/-/commit/4b522b9adf8d8609e8f64a3943a49db484db882d
[2891a55]: https://gitlab.com/gondolyr/mangadex-api/-/commit/2891a55a1991916b25d1c7118fe6c038216fa0ec
[0375fe6]: https://gitlab.com/gondolyr/mangadex-api/-/commit/0375fe6fc46343ff4a07a38b1053c6aeb9d3819c
[2705240]: https://gitlab.com/gondolyr/mangadex-api/-/commit/27052400efdc3feecb6c3ce56c5505764cbf01d5

# Version 0.1.1 (2020-12-11)

## Improvements

- [Added `Copy` trait to internal MangaDex types.][ac533c0a]
- [Added `Hash` and `Serialize` to internal MangaDex types.][135f2c69]

## Documentation

- [Added GitLab pages job to publish Cargo-generated docs onto project website.][4d9065e1]
- [Fixed README example and v2 client docblocks return types.][f2197738]
- [Added Contributing guide.][21da4ca6]

## Examples

- [Added manga cover image downloader.][e9980599]
- [Added chapter downloader.][2f04b936]

## Internal Only

- [Moved `TagCategory` out of `tag` module to `tag_category`.][883b0e15]
- [Removed `getset` crate and implemented own getters.][da206ffc]

[4d9065e1]: https://gitlab.com/gondolyr/mangadex-api/-/commit/4d9065e180c87f1bd4be781171714b6d52e2f9ed
[f2197738]: https://gitlab.com/gondolyr/mangadex-api/-/commit/f219773828538783267eed7cf0534724735566c9
[21da4ca6]: https://gitlab.com/gondolyr/mangadex-api/-/commit/21da4ca6c12f282b086a835760e9616174242b67
[e9980599]: https://gitlab.com/gondolyr/mangadex-api/-/commit/e9980599c50073d621edc31e85cd6a6c89764788
[ac533c0a]: https://gitlab.com/gondolyr/mangadex-api/-/commit/ac533c0a05183d4e678387dd148551a4bc575fdf
[883b0e15]: https://gitlab.com/gondolyr/mangadex-api/-/commit/883b0e158bcc8835be075c10803c42362c5f3fe1
[135f2c69]: https://gitlab.com/gondolyr/mangadex-api/-/commit/135f2c69b39ea304ed0e29e3b0f301c668d08c6d
[2f04b936]: https://gitlab.com/gondolyr/mangadex-api/-/commit/2f04b93667390b28729d910759f206670819780b
[da206ffc]: https://gitlab.com/gondolyr/mangadex-api/-/commit/da206ffca29657173dd1f28e2a475468657fc9b2

# Version 0.1.0 (2020-12-06)

## Features

- [All (most) MangaDex v2 endpoints implemented as of 2020-12-06.][endpoints]
  - API index page is not implemented. At this time, there is no intention to implement this unless there is strong demand.
- [Can log in to access restricted endpoints.][d8f794f8]
- [Chrono is a feature that will transmute various date/time fields as Chrono types][9d71c29b]
- [Example CLI tool for calling all the implemented v2 endpoints.][6c1f024c]
    - This does not have a lot of customization as it is designed to demonstrate basic usage.
- [Many MangaDex types have been internalized to Rust enums and structs for ease-of-use.][types]

[9d71c29b]: https://gitlab.com/gondolyr/mangadex-api/-/commit/9d71c29b3ca41201fe89b3fd351cc8792a522522
[6c1f024c]: https://gitlab.com/gondolyr/mangadex-api/-/commit/6c1f024cde9cd396e0fd0b260b0f82c455eccd40
[d8f794f8]: https://gitlab.com/gondolyr/mangadex-api/-/commit/d8f794f860f8b93c306fd52e7ba61d013c88bc1f
[endpoints]: https://gitlab.com/gondolyr/mangadex-api/-/tree/0.1.0/src/v2/builder
[types]: https://gitlab.com/gondolyr/mangadex-api/-/tree/0.1.0/src/types
