#![allow(non_snake_case)]
//! mako is a high performance data handling library
/// Tokenization module handles all tokenization and untokenization
#[cfg(not(doctest))]
pub mod tokenization;
/// Vocab module contains the Railgun vocab object and the functions to load different vocabularies
pub mod vocab;
/// Batching module contains several utilities for dealing with batches, such as shuffling and sorting batches
pub mod batching;
/// Len contains the Len trait implemented for several types
pub mod len;

extern crate log;
#[macro_use]
extern crate lazy_static;

#[macro_use]
extern crate derive_builder;