/// Len trait
pub trait Len {
    fn len(&self) -> usize;
}

// Implementations
impl Len for str {
    fn len(&self) -> usize {
        self.len()
    }
}

impl Len for String {
    fn len(&self) -> usize {
        self.len()
    }
}

impl<T> Len for Vec<T> {
    fn len(&self) -> usize {
        self.len()
    }
}

impl<T> Len for [T] {
    fn len(&self) -> usize {
        self.len()
    }
}

impl Len for pyo3::PyAny {
    fn len(&self) -> usize {
        self.len().expect("Failed to get length!")
    }
}

impl Len for &pyo3::PyAny {
    fn len(&self) -> usize {
        (*self).len().expect("Failed to get length!")
    }
}