# 共同作成者ガイド

本プロジェクトの共同開発者ガイドへようこそ。

## プロジェクトを作成する

実行ファイルを作成する場合は、次のコマンドを実行します。<名前>の部分には実行ファイルに付ける名前を入れます。

```shell
cargo init . --name <名前>
```

ライブラリーを作成する場合は、`--lib` オプションを付けます。

```shell
cargo init . --name <名前> --lib
```

> プロジェクトを作成し終えたら、この章の内容は不要なので削除してください

## プロジェクトのビルド・テスト

2つの方法があります。

- `cargo build` や `cargo test` - パッと行うときに便利です
- `python3 ./build.py` - テストレポート、カバレッジレポート、リリースビルドをセットで行います

## build.py について

`cargo` で

- Rust コードのコンパイル
- ビルド前のスクリプトの実行

が提供されていますが、以下を手軽に行えない、またはサポートされていません。

- Web Assembly へのコンパイル
- ビルド後のスクリプトの実行
- カバレッジレポートの作成

これらを行いやすくするため、`build.py` を設けています。
利用のしかたは `python3 ./build.py --help` でご確認ください。

## プロジェクトの構成

```shell
root
+ .gitignore        コミット除外するファイルの設定
+ build.json        サブコマンドの設定
+ build.py          ビルドスクリプト
+ CONTRIBUTING.md   共同作成者ガイド
```