//! Kadmelia distributed hash table
#![warn(missing_docs)]
#![feature(drain_filter)]
#![feature(btree_drain_filter)]
#![feature(map_first_last)]
#![feature(duration_constants)]
#![allow(dead_code)]

mod directory;
mod error;
mod id;
mod message;
mod node;
mod node_info;
mod serde;
mod table;
mod timer;
mod token;
mod transport;
mod txid;

#[cfg(test)]
mod testnet;

pub use error::{Error, Result};
pub use id::{Id, InfoHash};
pub use node::{Announce, Handle, Node, Router};
pub use transport::Transport;
