//! Kadmelia distributed hash table
#![warn(missing_docs)]
#![feature(drain_filter, btree_drain_filter, map_first_last, duration_constants)]
#![allow(unused_variables, dead_code)]

mod directory;
mod error;
mod id;
mod message;
mod node;
mod node_info;
mod serde;
mod table;
mod timer;
mod token;
mod transport;
mod txid;

#[cfg(test)]
mod testnet;

pub use error::{Error, Result};
pub use id::InfoHash;
pub use node::{Node, SearchHandle};
pub use transport::Transport;
