/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// ThreadProjection : A thread is a message thread created for a message received by an alias



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ThreadProjection {
    #[serde(rename = "aliasId")]
    pub alias_id: String,
    #[serde(rename = "bcc", skip_serializing_if = "Option::is_none")]
    pub bcc: Option<Vec<String>>,
    #[serde(rename = "cc", skip_serializing_if = "Option::is_none")]
    pub cc: Option<Vec<String>>,
    #[serde(rename = "createdAt")]
    pub created_at: String,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "inboxId")]
    pub inbox_id: String,
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(rename = "to")]
    pub to: Vec<String>,
    #[serde(rename = "updatedAt")]
    pub updated_at: String,
    #[serde(rename = "userId")]
    pub user_id: String,
}

impl ThreadProjection {
    /// A thread is a message thread created for a message received by an alias
    pub fn new(alias_id: String, created_at: String, id: String, inbox_id: String, to: Vec<String>, updated_at: String, user_id: String) -> ThreadProjection {
        ThreadProjection {
            alias_id,
            bcc: None,
            cc: None,
            created_at,
            id,
            inbox_id,
            name: None,
            subject: None,
            to,
            updated_at,
            user_id,
        }
    }
}


