/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// ExportOptions : Options for exporting user data



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExportOptions {
    #[serde(rename = "outputFormat")]
    pub output_format: OutputFormat,
    #[serde(rename = "excludePreviouslyExported", skip_serializing_if = "Option::is_none")]
    pub exclude_previously_exported: Option<bool>,
    #[serde(rename = "createdEarliestTime", skip_serializing_if = "Option::is_none")]
    pub created_earliest_time: Option<String>,
    #[serde(rename = "createdOldestTime", skip_serializing_if = "Option::is_none")]
    pub created_oldest_time: Option<String>,
    #[serde(rename = "filter", skip_serializing_if = "Option::is_none")]
    pub filter: Option<String>,
    #[serde(rename = "listSeparatorToken", skip_serializing_if = "Option::is_none")]
    pub list_separator_token: Option<serde_json::Value>,
}

impl ExportOptions {
    /// Options for exporting user data
    pub fn new(output_format: OutputFormat) -> ExportOptions {
        ExportOptions {
            output_format,
            exclude_previously_exported: None,
            created_earliest_time: None,
            created_oldest_time: None,
            filter: None,
            list_separator_token: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum OutputFormat {
    #[serde(rename = "CSV_DEFAULT")]
    DEFAULT,
    #[serde(rename = "CSV_EXCEL")]
    EXCEL,
}

