/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// WebhookNewEmailPayload : NEW_EMAIL webhook payload. Sent to your webhook url endpoint via HTTP POST when an email is received by the inbox that your webhook is attached to. Use the email ID to fetch the full email body or attachments.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct WebhookNewEmailPayload {
    /// List of attachment meta data objects if attachments present
    #[serde(rename = "attachmentMetaDatas", skip_serializing_if = "Option::is_none")]
    pub attachment_meta_datas: Option<Vec<crate::models::AttachmentMetaData>>,
    /// List of `BCC` recipients email addresses that the email was addressed to. See recipients object for names.
    #[serde(rename = "bcc", skip_serializing_if = "Option::is_none")]
    pub bcc: Option<Vec<String>>,
    /// List of `CC` recipients email addresses that the email was addressed to. See recipients object for names.
    #[serde(rename = "cc", skip_serializing_if = "Option::is_none")]
    pub cc: Option<Vec<String>>,
    /// Date time of event creation
    #[serde(rename = "createdAt", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    /// ID of the email that was received. Use this ID for fetching the email with the `EmailController`.
    #[serde(rename = "emailId", skip_serializing_if = "Option::is_none")]
    pub email_id: Option<String>,
    /// Name of the event type webhook is being triggered for.
    #[serde(rename = "eventName", skip_serializing_if = "Option::is_none")]
    pub event_name: Option<EventName>,
    /// Who the email was sent from. An email address - see fromName for the sender name.
    #[serde(rename = "from", skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    /// Id of the inbox that received an email
    #[serde(rename = "inboxId", skip_serializing_if = "Option::is_none")]
    pub inbox_id: Option<String>,
    /// Idempotent message ID. Store this ID locally or in a database to prevent message duplication.
    #[serde(rename = "messageId", skip_serializing_if = "Option::is_none")]
    pub message_id: Option<String>,
    /// The subject line of the email message as specified by SMTP subject header
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    /// List of `To` recipient email addresses that the email was addressed to. See recipients object for names.
    #[serde(rename = "to", skip_serializing_if = "Option::is_none")]
    pub to: Option<Vec<String>>,
    /// ID of webhook entity being triggered
    #[serde(rename = "webhookId", skip_serializing_if = "Option::is_none")]
    pub webhook_id: Option<String>,
    /// Name of the webhook being triggered
    #[serde(rename = "webhookName", skip_serializing_if = "Option::is_none")]
    pub webhook_name: Option<String>,
}

impl WebhookNewEmailPayload {
    /// NEW_EMAIL webhook payload. Sent to your webhook url endpoint via HTTP POST when an email is received by the inbox that your webhook is attached to. Use the email ID to fetch the full email body or attachments.
    pub fn new() -> WebhookNewEmailPayload {
        WebhookNewEmailPayload {
            attachment_meta_datas: None,
            bcc: None,
            cc: None,
            created_at: None,
            email_id: None,
            event_name: None,
            from: None,
            inbox_id: None,
            message_id: None,
            subject: None,
            to: None,
            webhook_id: None,
            webhook_name: None,
        }
    }
}

/// Name of the event type webhook is being triggered for.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum EventName {
    #[serde(rename = "EMAIL_RECEIVED")]
    EMAILRECEIVED,
    #[serde(rename = "NEW_EMAIL")]
    NEWEMAIL,
    #[serde(rename = "NEW_CONTACT")]
    NEWCONTACT,
    #[serde(rename = "NEW_ATTACHMENT")]
    NEWATTACHMENT,
    #[serde(rename = "EMAIL_OPENED")]
    EMAILOPENED,
    #[serde(rename = "EMAIL_READ")]
    EMAILREAD,
}

