/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// BulkSendEmailOptions : Options for bulk sending an email from multiple addresses. See regular `sendEmail` methods for more information.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct BulkSendEmailOptions {
    /// Inboxes to send the email from
    #[serde(rename = "inboxIds", skip_serializing_if = "Option::is_none")]
    pub inbox_ids: Option<Vec<String>>,
    #[serde(rename = "sendEmailOptions", skip_serializing_if = "Option::is_none")]
    pub send_email_options: Option<Box<crate::models::SendEmailOptions>>,
}

impl BulkSendEmailOptions {
    /// Options for bulk sending an email from multiple addresses. See regular `sendEmail` methods for more information.
    pub fn new() -> BulkSendEmailOptions {
        BulkSendEmailOptions {
            inbox_ids: None,
            send_email_options: None,
        }
    }
}


