/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// VerifyEmailAddressOptions : Options for verifying that an email address exists at a remote mail server.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct VerifyEmailAddressOptions {
    #[serde(rename = "mailServerDomain", skip_serializing_if = "Option::is_none")]
    pub mail_server_domain: Option<String>,
    #[serde(rename = "emailAddress")]
    pub email_address: String,
    #[serde(rename = "senderEmailAddress", skip_serializing_if = "Option::is_none")]
    pub sender_email_address: Option<String>,
    #[serde(rename = "port", skip_serializing_if = "Option::is_none")]
    pub port: Option<i32>,
}

impl VerifyEmailAddressOptions {
    /// Options for verifying that an email address exists at a remote mail server.
    pub fn new(email_address: String) -> VerifyEmailAddressOptions {
        VerifyEmailAddressOptions {
            mail_server_domain: None,
            email_address,
            sender_email_address: None,
            port: None,
        }
    }
}


