/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// EmailProjection : A compact representation of a full email. Used in list endpoints to keep response sizes low. Body and attachments are not included. To get all fields of the email use the `getEmail` method with the email projection's ID. See `EmailDto` for documentation on projection properties.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EmailProjection {
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<String>>,
    #[serde(rename = "bcc", skip_serializing_if = "Option::is_none")]
    pub bcc: Option<Vec<String>>,
    #[serde(rename = "bodyExcerpt", skip_serializing_if = "Option::is_none")]
    pub body_excerpt: Option<String>,
    #[serde(rename = "bodyMD5Hash", skip_serializing_if = "Option::is_none")]
    pub body_md5_hash: Option<String>,
    #[serde(rename = "cc", skip_serializing_if = "Option::is_none")]
    pub cc: Option<Vec<String>>,
    #[serde(rename = "createdAt")]
    pub created_at: String,
    #[serde(rename = "from", skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "inboxId")]
    pub inbox_id: String,
    #[serde(rename = "read", skip_serializing_if = "Option::is_none")]
    pub read: Option<bool>,
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(rename = "teamAccess", skip_serializing_if = "Option::is_none")]
    pub team_access: Option<bool>,
    #[serde(rename = "to")]
    pub to: Vec<String>,
}

impl EmailProjection {
    /// A compact representation of a full email. Used in list endpoints to keep response sizes low. Body and attachments are not included. To get all fields of the email use the `getEmail` method with the email projection's ID. See `EmailDto` for documentation on projection properties.
    pub fn new(created_at: String, id: String, inbox_id: String, to: Vec<String>) -> EmailProjection {
        EmailProjection {
            attachments: None,
            bcc: None,
            body_excerpt: None,
            body_md5_hash: None,
            cc: None,
            created_at,
            from: None,
            id,
            inbox_id,
            read: None,
            subject: None,
            team_access: None,
            to,
        }
    }
}


