/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// EmailPreview : Preview of an email message. For full message (including body and attachments) call the `getEmail` or other email endpoints with the provided email ID.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EmailPreview {
    /// List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension.
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<String>>,
    /// List of `BCC` recipients email addresses that the email was addressed to. See recipients object for names.
    #[serde(rename = "bcc", skip_serializing_if = "Option::is_none")]
    pub bcc: Option<Vec<String>>,
    /// List of `CC` recipients email addresses that the email was addressed to. See recipients object for names.
    #[serde(rename = "cc", skip_serializing_if = "Option::is_none")]
    pub cc: Option<Vec<String>>,
    /// When was the email received by MailSlurp
    #[serde(rename = "createdAt", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    /// Who the email was sent from. An email address - see fromName for the sender name.
    #[serde(rename = "from", skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    /// ID of the email entity
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Read flag. Has the email ever been viewed in the dashboard or fetched via the API with a hydrated body? If so the email is marked as read. Paginated results do not affect read status. Read status is different to email opened event as it depends on your own account accessing the email. Email opened is determined by tracking pixels sent to other uses if enable during sending. You can listened for both email read and email opened events using webhooks.
    #[serde(rename = "read", skip_serializing_if = "Option::is_none")]
    pub read: Option<bool>,
    /// The subject line of the email message as specified by SMTP subject header
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    /// List of `To` recipient email addresses that the email was addressed to. See recipients object for names.
    #[serde(rename = "to", skip_serializing_if = "Option::is_none")]
    pub to: Option<Vec<String>>,
}

impl EmailPreview {
    /// Preview of an email message. For full message (including body and attachments) call the `getEmail` or other email endpoints with the provided email ID.
    pub fn new() -> EmailPreview {
        EmailPreview {
            attachments: None,
            bcc: None,
            cc: None,
            created_at: None,
            from: None,
            id: None,
            read: None,
            subject: None,
            to: None,
        }
    }
}


