/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method `create_new_inbox_forwarder`
#[derive(Clone, Debug)]
pub struct CreateNewInboxForwarderParams {
    /// createInboxForwarderOptions
    pub create_inbox_forwarder_options: crate::models::CreateInboxForwarderOptions,
    /// Inbox id to attach forwarder to
    pub inbox_id: Option<String>
}

/// struct for passing parameters to the method `delete_inbox_forwarder`
#[derive(Clone, Debug)]
pub struct DeleteInboxForwarderParams {
    /// ID of inbox forwarder
    pub id: String
}

/// struct for passing parameters to the method `delete_inbox_forwarders`
#[derive(Clone, Debug)]
pub struct DeleteInboxForwardersParams {
    /// Optional inbox id to attach forwarder to
    pub inbox_id: Option<String>
}

/// struct for passing parameters to the method `get_inbox_forwarder`
#[derive(Clone, Debug)]
pub struct GetInboxForwarderParams {
    /// ID of inbox forwarder
    pub id: String
}

/// struct for passing parameters to the method `get_inbox_forwarders`
#[derive(Clone, Debug)]
pub struct GetInboxForwardersParams {
    /// Optional inbox id to get forwarders from
    pub inbox_id: Option<String>,
    /// Optional page index in inbox forwarder list pagination
    pub page: Option<i32>,
    /// Optional search filter
    pub search_filter: Option<String>,
    /// Optional page size in inbox forwarder list pagination
    pub size: Option<i32>,
    /// Optional createdAt sort direction ASC or DESC
    pub sort: Option<String>
}

/// struct for passing parameters to the method `test_inbox_forwarder`
#[derive(Clone, Debug)]
pub struct TestInboxForwarderParams {
    /// ID of inbox forwarder
    pub id: String,
    /// inboxForwarderTestOptions
    pub inbox_forwarder_test_options: crate::models::InboxForwarderTestOptions
}

/// struct for passing parameters to the method `test_inbox_forwarders_for_inbox`
#[derive(Clone, Debug)]
pub struct TestInboxForwardersForInboxParams {
    /// ID of inbox
    pub inbox_id: String,
    /// inboxForwarderTestOptions
    pub inbox_forwarder_test_options: crate::models::InboxForwarderTestOptions
}

/// struct for passing parameters to the method `test_new_inbox_forwarder`
#[derive(Clone, Debug)]
pub struct TestNewInboxForwarderParams {
    /// testNewInboxForwarderOptions
    pub test_new_inbox_forwarder_options: crate::models::TestNewInboxForwarderOptions
}


/// struct for typed errors of method `create_new_inbox_forwarder`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateNewInboxForwarderError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `delete_inbox_forwarder`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteInboxForwarderError {
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `delete_inbox_forwarders`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DeleteInboxForwardersError {
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `get_inbox_forwarder`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetInboxForwarderError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `get_inbox_forwarders`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetInboxForwardersError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `test_inbox_forwarder`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestInboxForwarderError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `test_inbox_forwarders_for_inbox`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestInboxForwardersForInboxError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `test_new_inbox_forwarder`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestNewInboxForwarderError {
    Status401(),
    Status403(),
    UnknownValue(serde_json::Value),
}


/// Create a new inbox rule for forwarding, blocking, and allowing emails when sending and receiving
pub async fn create_new_inbox_forwarder(configuration: &configuration::Configuration, params: CreateNewInboxForwarderParams) -> Result<crate::models::InboxForwarderDto, Error<CreateNewInboxForwarderError>> {
    // unbox the parameters
    let create_inbox_forwarder_options = params.create_inbox_forwarder_options;
    let inbox_id = params.inbox_id;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders", configuration.base_path);
    let mut local_var_req_builder = local_var_client.post(local_var_uri_str.as_str());

    if let Some(ref local_var_str) = inbox_id {
        local_var_req_builder = local_var_req_builder.query(&[("inboxId", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&create_inbox_forwarder_options);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<CreateNewInboxForwarderError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Delete inbox forwarder
pub async fn delete_inbox_forwarder(configuration: &configuration::Configuration, params: DeleteInboxForwarderParams) -> Result<(), Error<DeleteInboxForwarderError>> {
    // unbox the parameters
    let id = params.id;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders/{id}", configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.delete(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<DeleteInboxForwarderError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Delete inbox forwarders. Accepts optional inboxId filter.
pub async fn delete_inbox_forwarders(configuration: &configuration::Configuration, params: DeleteInboxForwardersParams) -> Result<(), Error<DeleteInboxForwardersError>> {
    // unbox the parameters
    let inbox_id = params.inbox_id;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders", configuration.base_path);
    let mut local_var_req_builder = local_var_client.delete(local_var_uri_str.as_str());

    if let Some(ref local_var_str) = inbox_id {
        local_var_req_builder = local_var_req_builder.query(&[("inboxId", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<DeleteInboxForwardersError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Get inbox ruleset
pub async fn get_inbox_forwarder(configuration: &configuration::Configuration, params: GetInboxForwarderParams) -> Result<crate::models::InboxForwarderDto, Error<GetInboxForwarderError>> {
    // unbox the parameters
    let id = params.id;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders/{id}", configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.get(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetInboxForwarderError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// List all forwarders attached to an inbox
pub async fn get_inbox_forwarders(configuration: &configuration::Configuration, params: GetInboxForwardersParams) -> Result<crate::models::PageInboxForwarderDto, Error<GetInboxForwardersError>> {
    // unbox the parameters
    let inbox_id = params.inbox_id;
    let page = params.page;
    let search_filter = params.search_filter;
    let size = params.size;
    let sort = params.sort;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders", configuration.base_path);
    let mut local_var_req_builder = local_var_client.get(local_var_uri_str.as_str());

    if let Some(ref local_var_str) = inbox_id {
        local_var_req_builder = local_var_req_builder.query(&[("inboxId", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = page {
        local_var_req_builder = local_var_req_builder.query(&[("page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_filter {
        local_var_req_builder = local_var_req_builder.query(&[("searchFilter", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = size {
        local_var_req_builder = local_var_req_builder.query(&[("size", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sort {
        local_var_req_builder = local_var_req_builder.query(&[("sort", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetInboxForwardersError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Test an inbox forwarder
pub async fn test_inbox_forwarder(configuration: &configuration::Configuration, params: TestInboxForwarderParams) -> Result<crate::models::InboxForwarderTestResult, Error<TestInboxForwarderError>> {
    // unbox the parameters
    let id = params.id;
    let inbox_forwarder_test_options = params.inbox_forwarder_test_options;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders/{id}/test", configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.post(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&inbox_forwarder_test_options);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<TestInboxForwarderError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Test inbox forwarders for inbox
pub async fn test_inbox_forwarders_for_inbox(configuration: &configuration::Configuration, params: TestInboxForwardersForInboxParams) -> Result<crate::models::InboxForwarderTestResult, Error<TestInboxForwardersForInboxError>> {
    // unbox the parameters
    let inbox_id = params.inbox_id;
    let inbox_forwarder_test_options = params.inbox_forwarder_test_options;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders", configuration.base_path);
    let mut local_var_req_builder = local_var_client.put(local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("inboxId", &inbox_id.to_string())]);
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&inbox_forwarder_test_options);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<TestInboxForwardersForInboxError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Test new inbox forwarder
pub async fn test_new_inbox_forwarder(configuration: &configuration::Configuration, params: TestNewInboxForwarderParams) -> Result<crate::models::InboxForwarderTestResult, Error<TestNewInboxForwarderError>> {
    // unbox the parameters
    let test_new_inbox_forwarder_options = params.test_new_inbox_forwarder_options;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/forwarders", configuration.base_path);
    let mut local_var_req_builder = local_var_client.patch(local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&test_new_inbox_forwarder_options);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<TestNewInboxForwarderError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

