/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct MissedEmail {
    #[serde(rename = "attachmentCount")]
    pub attachment_count: i32,
    #[serde(rename = "bcc")]
    pub bcc: Vec<String>,
    #[serde(rename = "bodyExcerpt", skip_serializing_if = "Option::is_none")]
    pub body_excerpt: Option<String>,
    #[serde(rename = "cc")]
    pub cc: Vec<String>,
    #[serde(rename = "createdAt")]
    pub created_at: String,
    #[serde(rename = "from", skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    #[serde(rename = "inboxIds")]
    pub inbox_ids: Vec<String>,
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    #[serde(rename = "to")]
    pub to: Vec<String>,
    #[serde(rename = "updatedAt")]
    pub updated_at: String,
    #[serde(rename = "userId")]
    pub user_id: String,
}

impl MissedEmail {
    pub fn new(attachment_count: i32, bcc: Vec<String>, cc: Vec<String>, created_at: String, inbox_ids: Vec<String>, to: Vec<String>, updated_at: String, user_id: String) -> MissedEmail {
        MissedEmail {
            attachment_count,
            bcc,
            body_excerpt: None,
            cc,
            created_at,
            from: None,
            id: None,
            inbox_ids,
            subject: None,
            to,
            updated_at,
            user_id,
        }
    }
}


