/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// DomainPreview : Preview object for domain entity



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DomainPreview {
    #[serde(rename = "catchAllInboxId", skip_serializing_if = "Option::is_none")]
    pub catch_all_inbox_id: Option<String>,
    #[serde(rename = "createdAt")]
    pub created_at: String,
    #[serde(rename = "domain")]
    pub domain: String,
    #[serde(rename = "domainType")]
    pub domain_type: DomainType,
    #[serde(rename = "id")]
    pub id: String,
    #[serde(rename = "isVerified")]
    pub is_verified: bool,
}

impl DomainPreview {
    /// Preview object for domain entity
    pub fn new(created_at: String, domain: String, domain_type: DomainType, id: String, is_verified: bool) -> DomainPreview {
        DomainPreview {
            catch_all_inbox_id: None,
            created_at,
            domain,
            domain_type,
            id,
            is_verified,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum DomainType {
    #[serde(rename = "HTTP_INBOX")]
    HTTPINBOX,
    #[serde(rename = "SMTP_DOMAIN")]
    SMTPDOMAIN,
}

