/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// SentEmailDto : Sent email details



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct SentEmailDto {
    /// Array of IDs of attachments that were sent with this email
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<String>>,
    #[serde(rename = "bcc", skip_serializing_if = "Option::is_none")]
    pub bcc: Option<Vec<String>>,
    #[serde(rename = "body", skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    /// MD5 Hash
    #[serde(rename = "bodyMD5Hash", skip_serializing_if = "Option::is_none")]
    pub body_md5_hash: Option<String>,
    #[serde(rename = "cc", skip_serializing_if = "Option::is_none")]
    pub cc: Option<Vec<String>>,
    #[serde(rename = "charset", skip_serializing_if = "Option::is_none")]
    pub charset: Option<String>,
    #[serde(rename = "from", skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    /// ID of sent email
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Inbox ID email was sent from
    #[serde(rename = "inboxId", skip_serializing_if = "Option::is_none")]
    pub inbox_id: Option<String>,
    #[serde(rename = "isHTML", skip_serializing_if = "Option::is_none")]
    pub is_html: Option<bool>,
    #[serde(rename = "replyTo", skip_serializing_if = "Option::is_none")]
    pub reply_to: Option<String>,
    #[serde(rename = "sentAt")]
    pub sent_at: String,
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    /// Recipients email was sent to
    #[serde(rename = "to", skip_serializing_if = "Option::is_none")]
    pub to: Option<Vec<String>>,
    /// User ID
    #[serde(rename = "userId", skip_serializing_if = "Option::is_none")]
    pub user_id: Option<String>,
}

impl SentEmailDto {
    /// Sent email details
    pub fn new(sent_at: String) -> SentEmailDto {
        SentEmailDto {
            attachments: None,
            bcc: None,
            body: None,
            body_md5_hash: None,
            cc: None,
            charset: None,
            from: None,
            id: None,
            inbox_id: None,
            is_html: None,
            reply_to: None,
            sent_at,
            subject: None,
            to: None,
            user_id: None,
        }
    }
}


