/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// AbstractWebhookPayload : Abstract webhook payload. Use the correct payload type for your webhook event type in order to access all the specific properties for that event. See the `NEW_EMAIL`,`NEW_CONTACT` and `NEW_ATTACHMENT` payloads for the properties available for those events.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct AbstractWebhookPayload {
    #[serde(rename = "eventName")]
    pub event_name: EventName,
    #[serde(rename = "messageId")]
    pub message_id: String,
    #[serde(rename = "webhookId")]
    pub webhook_id: String,
    #[serde(rename = "webhookName", skip_serializing_if = "Option::is_none")]
    pub webhook_name: Option<String>,
}

impl AbstractWebhookPayload {
    /// Abstract webhook payload. Use the correct payload type for your webhook event type in order to access all the specific properties for that event. See the `NEW_EMAIL`,`NEW_CONTACT` and `NEW_ATTACHMENT` payloads for the properties available for those events.
    pub fn new(event_name: EventName, message_id: String, webhook_id: String) -> AbstractWebhookPayload {
        AbstractWebhookPayload {
            event_name,
            message_id,
            webhook_id,
            webhook_name: None,
        }
    }
}

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum EventName {
    #[serde(rename = "EMAIL_RECEIVED")]
    EMAILRECEIVED,
    #[serde(rename = "NEW_EMAIL")]
    NEWEMAIL,
    #[serde(rename = "NEW_CONTACT")]
    NEWCONTACT,
    #[serde(rename = "NEW_ATTACHMENT")]
    NEWATTACHMENT,
}

