/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method `export_entities`
#[derive(Clone, Debug)]
pub struct ExportEntitiesParams {
    /// apiKey
    pub api_key: String,
    /// exportType
    pub export_type: String,
    /// outputFormat
    pub output_format: String,
    /// createdEarliestTime
    pub created_earliest_time: Option<String>,
    /// createdOldestTime
    pub created_oldest_time: Option<String>,
    /// excludePreviouslyExported
    pub exclude_previously_exported: Option<bool>,
    /// filter
    pub filter: Option<String>,
    /// listSeparatorToken
    pub list_separator_token: Option<String>
}

/// struct for passing parameters to the method `get_export_link`
#[derive(Clone, Debug)]
pub struct GetExportLinkParams {
    /// exportType
    pub export_type: String,
    /// exportOptions
    pub export_options: crate::models::ExportOptions,
    /// apiKey
    pub api_key: Option<String>
}


/// struct for typed errors of method `export_entities`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ExportEntitiesError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `get_export_link`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetExportLinkError {
    Status401(),
    Status403(),
    Status404(),
    UnknownValue(serde_json::Value),
}


pub async fn export_entities(configuration: &configuration::Configuration, params: ExportEntitiesParams) -> Result<String, Error<ExportEntitiesError>> {
    // unbox the parameters
    let api_key = params.api_key;
    let export_type = params.export_type;
    let output_format = params.output_format;
    let created_earliest_time = params.created_earliest_time;
    let created_oldest_time = params.created_oldest_time;
    let exclude_previously_exported = params.exclude_previously_exported;
    let filter = params.filter;
    let list_separator_token = params.list_separator_token;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/export", configuration.base_path);
    let mut local_var_req_builder = local_var_client.get(local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("apiKey", &api_key.to_string())]);
    if let Some(ref local_var_str) = created_earliest_time {
        local_var_req_builder = local_var_req_builder.query(&[("createdEarliestTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_oldest_time {
        local_var_req_builder = local_var_req_builder.query(&[("createdOldestTime", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = exclude_previously_exported {
        local_var_req_builder = local_var_req_builder.query(&[("excludePreviouslyExported", &local_var_str.to_string())]);
    }
    local_var_req_builder = local_var_req_builder.query(&[("exportType", &export_type.to_string())]);
    if let Some(ref local_var_str) = filter {
        local_var_req_builder = local_var_req_builder.query(&[("filter", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_separator_token {
        local_var_req_builder = local_var_req_builder.query(&[("listSeparatorToken", &local_var_str.to_string())]);
    }
    local_var_req_builder = local_var_req_builder.query(&[("outputFormat", &output_format.to_string())]);
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ExportEntitiesError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

pub async fn get_export_link(configuration: &configuration::Configuration, params: GetExportLinkParams) -> Result<crate::models::ExportLink, Error<GetExportLinkError>> {
    // unbox the parameters
    let export_type = params.export_type;
    let export_options = params.export_options;
    let api_key = params.api_key;


    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/export", configuration.base_path);
    let mut local_var_req_builder = local_var_client.post(local_var_uri_str.as_str());

    if let Some(ref local_var_str) = api_key {
        local_var_req_builder = local_var_req_builder.query(&[("apiKey", &local_var_str.to_string())]);
    }
    local_var_req_builder = local_var_req_builder.query(&[("exportType", &export_type.to_string())]);
    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("x-api-key", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&export_options);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetExportLinkError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

