/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// EmailVerificationResult : Email verification result. Valid means email address exists according to response from mail server running at the domian and port given.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EmailVerificationResult {
    #[serde(rename = "domainName")]
    pub domain_name: String,
    #[serde(rename = "emailAddress")]
    pub email_address: String,
    #[serde(rename = "error", skip_serializing_if = "Option::is_none")]
    pub error: Option<String>,
    #[serde(rename = "isValid")]
    pub is_valid: bool,
    #[serde(rename = "port")]
    pub port: i32,
}

impl EmailVerificationResult {
    /// Email verification result. Valid means email address exists according to response from mail server running at the domian and port given.
    pub fn new(domain_name: String, email_address: String, is_valid: bool, port: i32) -> EmailVerificationResult {
        EmailVerificationResult {
            domain_name,
            email_address,
            error: None,
            is_valid,
            port,
        }
    }
}


