/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// ExpirationDefaults : Expiration defaults for your account



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ExpirationDefaults {
    #[serde(rename = "canPermanentInbox")]
    pub can_permanent_inbox: bool,
    #[serde(rename = "defaultExpirationMillis", skip_serializing_if = "Option::is_none")]
    pub default_expiration_millis: Option<i64>,
    #[serde(rename = "defaultExpiresAt", skip_serializing_if = "Option::is_none")]
    pub default_expires_at: Option<String>,
    #[serde(rename = "maxExpirationMillis", skip_serializing_if = "Option::is_none")]
    pub max_expiration_millis: Option<i64>,
}

impl ExpirationDefaults {
    /// Expiration defaults for your account
    pub fn new(can_permanent_inbox: bool) -> ExpirationDefaults {
        ExpirationDefaults {
            can_permanent_inbox,
            default_expiration_millis: None,
            default_expires_at: None,
            max_expiration_millis: None,
        }
    }
}


