/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateContactOptions {
    /// Set of email addresses belonging to the contact
    #[serde(rename = "emailAddresses", skip_serializing_if = "Option::is_none")]
    pub email_addresses: Option<Vec<String>>,
    #[serde(rename = "firstName", skip_serializing_if = "Option::is_none")]
    pub first_name: Option<String>,
    /// Group IDs that contact belongs to
    #[serde(rename = "groupId", skip_serializing_if = "Option::is_none")]
    pub group_id: Option<String>,
    #[serde(rename = "metaData", skip_serializing_if = "Option::is_none")]
    pub meta_data: Option<serde_json::Value>,
    /// Has the user explicitly or implicitly opted out of being contacted? If so MailSlurp will ignore them in all actions.
    #[serde(rename = "optOut", skip_serializing_if = "Option::is_none")]
    pub opt_out: Option<bool>,
    /// Tags that can be used to search and group contacts
    #[serde(rename = "tags", skip_serializing_if = "Option::is_none")]
    pub tags: Option<Vec<String>>,
    #[serde(rename = "lastName", skip_serializing_if = "Option::is_none")]
    pub last_name: Option<String>,
    #[serde(rename = "company", skip_serializing_if = "Option::is_none")]
    pub company: Option<String>,
}

impl CreateContactOptions {
    pub fn new() -> CreateContactOptions {
        CreateContactOptions {
            email_addresses: None,
            first_name: None,
            group_id: None,
            meta_data: None,
            opt_out: None,
            tags: None,
            last_name: None,
            company: None,
        }
    }
}


