/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// EmailPreview : Preview of an email message. For full message (including body and attachments) call the `getEmail` or other email endpoints with the provided email ID.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct EmailPreview {
    /// List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension.
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<String>>,
    /// List of `BCC` recipients email was addressed to
    #[serde(rename = "bcc", skip_serializing_if = "Option::is_none")]
    pub bcc: Option<Vec<String>>,
    /// List of `CC` recipients email was addressed to
    #[serde(rename = "cc", skip_serializing_if = "Option::is_none")]
    pub cc: Option<Vec<String>>,
    /// When was the email received by MailSlurp
    #[serde(rename = "createdAt", skip_serializing_if = "Option::is_none")]
    pub created_at: Option<String>,
    /// Who the email was sent from
    #[serde(rename = "from", skip_serializing_if = "Option::is_none")]
    pub from: Option<String>,
    /// ID of the email
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<String>,
    /// Has the email been viewed ever. This means viewed in the dashboard or requested via the full email entity endpoints
    #[serde(rename = "read", skip_serializing_if = "Option::is_none")]
    pub read: Option<bool>,
    /// The subject line of the email message
    #[serde(rename = "subject", skip_serializing_if = "Option::is_none")]
    pub subject: Option<String>,
    /// List of `To` recipients email was addressed to
    #[serde(rename = "to", skip_serializing_if = "Option::is_none")]
    pub to: Option<Vec<String>>,
}

impl EmailPreview {
    /// Preview of an email message. For full message (including body and attachments) call the `getEmail` or other email endpoints with the provided email ID.
    pub fn new() -> EmailPreview {
        EmailPreview {
            attachments: None,
            bcc: None,
            cc: None,
            created_at: None,
            from: None,
            id: None,
            read: None,
            subject: None,
            to: None,
        }
    }
}


