/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// UploadAttachmentOptions : Options for uploading files for attachments. When sending emails with the API that require attachments first upload each attachment. Then use the returned attachment ID in your `SendEmailOptions` when sending an email. This way you can use attachments multiple times once they have been uploaded.



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct UploadAttachmentOptions {
    /// Base64 encoded string of file contents. Typically this means reading the bytes or string content of a file and then converting that to a base64 encoded string.
    #[serde(rename = "base64Contents", skip_serializing_if = "Option::is_none")]
    pub base64_contents: Option<String>,
    /// Optional contentType for file. For instance `application/pdf`
    #[serde(rename = "contentType", skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    /// Optional filename to save upload with. Will be the name that is shown in email clients
    #[serde(rename = "filename", skip_serializing_if = "Option::is_none")]
    pub filename: Option<String>,
}

impl UploadAttachmentOptions {
    /// Options for uploading files for attachments. When sending emails with the API that require attachments first upload each attachment. Then use the returned attachment ID in your `SendEmailOptions` when sending an email. This way you can use attachments multiple times once they have been uploaded.
    pub fn new() -> UploadAttachmentOptions {
        UploadAttachmentOptions {
            base64_contents: None,
            content_type: None,
            filename: None,
        }
    }
}


