/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// ReplyToAliasEmailOptions : Options for replying to an alias email using the alias inbox



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct ReplyToAliasEmailOptions {
    /// List of uploaded attachments to send with the reply. Optional.
    #[serde(rename = "attachments", skip_serializing_if = "Option::is_none")]
    pub attachments: Option<Vec<String>>,
    /// Body of the reply email you want to send
    #[serde(rename = "body", skip_serializing_if = "Option::is_none")]
    pub body: Option<String>,
    /// The charset that your message should be sent with. Optional. Default is UTF-8
    #[serde(rename = "charset", skip_serializing_if = "Option::is_none")]
    pub charset: Option<String>,
    /// Is the reply HTML
    #[serde(rename = "isHTML", skip_serializing_if = "Option::is_none")]
    pub is_html: Option<bool>,
    /// When to send the email. Typically immediately
    #[serde(rename = "sendStrategy", skip_serializing_if = "Option::is_none")]
    pub send_strategy: Option<SendStrategy>,
    /// Template ID to use instead of body. Will use template variable map to fill defined variable slots.
    #[serde(rename = "template", skip_serializing_if = "Option::is_none")]
    pub template: Option<String>,
    /// Template variables if using a template
    #[serde(rename = "templateVariables", skip_serializing_if = "Option::is_none")]
    pub template_variables: Option<serde_json::Value>,
}

impl ReplyToAliasEmailOptions {
    /// Options for replying to an alias email using the alias inbox
    pub fn new() -> ReplyToAliasEmailOptions {
        ReplyToAliasEmailOptions {
            attachments: None,
            body: None,
            charset: None,
            is_html: None,
            send_strategy: None,
            template: None,
            template_variables: None,
        }
    }
}

/// When to send the email. Typically immediately
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum SendStrategy {
    #[serde(rename = "SINGLE_MESSAGE")]
    SINGLEMESSAGE,
}

