/*
 * MailSlurp API
 *
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 * Generated by: https://openapi-generator.tech
 */

/// DownloadAttachmentDto : Content of attachment



#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct DownloadAttachmentDto {
    /// Base64 encoded string of attachment bytes. Decode the base64 encoded string to get the raw contents. If the file has a content type such as `text/html` you can read the contents directly by converting it to string using `utf-8` encoding.
    #[serde(rename = "base64FileContents", skip_serializing_if = "Option::is_none")]
    pub base64_file_contents: Option<String>,
    /// Content type of attachment. Examples are `image/png`, `application/msword`, `text/csv` etc.
    #[serde(rename = "contentType", skip_serializing_if = "Option::is_none")]
    pub content_type: Option<String>,
    /// Size in bytes of attachment content
    #[serde(rename = "sizeBytes", skip_serializing_if = "Option::is_none")]
    pub size_bytes: Option<i64>,
}

impl DownloadAttachmentDto {
    /// Content of attachment
    pub fn new() -> DownloadAttachmentDto {
        DownloadAttachmentDto {
            base64_file_contents: None,
            content_type: None,
            size_bytes: None,
        }
    }
}


